VERSION 2.00
Begin Form CreateBC 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Create a Barcode!"
   ClientHeight    =   4500
   ClientLeft      =   1392
   ClientTop       =   2148
   ClientWidth     =   8664
   Height          =   4920
   Icon            =   CREATEBC.FRX:0000
   Left            =   1344
   LinkTopic       =   "CreateBC"
   ScaleHeight     =   4500
   ScaleWidth      =   8664
   Top             =   1776
   Width           =   8760
   Begin ComboBox theScaleMode 
      Height          =   288
      Left            =   6720
      Style           =   2  'Dropdown List
      TabIndex        =   8
      Top             =   840
      Width           =   1788
   End
   Begin ComboBox AutoSize 
      Height          =   288
      Left            =   6720
      Style           =   2  'Dropdown List
      TabIndex        =   7
      Top             =   444
      Width           =   1284
   End
   Begin ComboBox Rotation 
      Height          =   288
      Left            =   1644
      Style           =   2  'Dropdown List
      TabIndex        =   6
      Top             =   2040
      Width           =   1848
   End
   Begin ComboBox Ratio 
      Height          =   288
      Left            =   1644
      Style           =   2  'Dropdown List
      TabIndex        =   5
      Top             =   1644
      Width           =   1008
   End
   Begin ComboBox BarCodeType 
      Height          =   288
      Left            =   1644
      Style           =   2  'Dropdown List
      TabIndex        =   4
      Top             =   1248
      Width           =   3360
   End
   Begin ComboBox CaptionPosition 
      Height          =   288
      Left            =   1644
      Style           =   2  'Dropdown List
      TabIndex        =   3
      Top             =   852
      Width           =   2472
   End
   Begin CommandButton ErrorBtn 
      Caption         =   "Last &Error"
      Height          =   432
      Left            =   5268
      TabIndex        =   15
      Top             =   2484
      Width           =   1404
   End
   Begin TextBox NarrWidth 
      Height          =   288
      Left            =   6720
      TabIndex        =   11
      Top             =   2028
      Width           =   852
   End
   Begin TextBox Text 
      Height          =   288
      Left            =   1644
      TabIndex        =   0
      Top             =   60
      Width           =   2712
   End
   Begin TextBox CaptionText 
      Height          =   288
      Left            =   1644
      TabIndex        =   2
      Top             =   456
      Width           =   2712
   End
   Begin TextBox TotalHeight 
      Height          =   288
      Left            =   6720
      TabIndex        =   9
      Top             =   1236
      Width           =   840
   End
   Begin CommandButton FontBtn 
      Caption         =   "&Font..."
      Height          =   432
      Left            =   336
      TabIndex        =   12
      Top             =   2484
      Width           =   1404
   End
   Begin CheckBox AutoCaption 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Auto Caption"
      Height          =   288
      Left            =   4500
      TabIndex        =   1
      Top             =   84
      Width           =   1512
   End
   Begin TextBox BarHeight 
      Height          =   288
      Left            =   6720
      TabIndex        =   10
      Top             =   1632
      Width           =   840
   End
   Begin CommandButton ClipboardBtn 
      Caption         =   "Clip&board"
      Height          =   432
      Left            =   3624
      TabIndex        =   14
      Top             =   2484
      Width           =   1404
   End
   Begin CommonDialog CMDialog1 
      CancelError     =   -1  'True
      Left            =   8196
      PrinterDefault  =   0   'False
      Top             =   1860
   End
   Begin CommandButton CancelBtn 
      Cancel          =   -1  'True
      Caption         =   "&Cancel"
      Height          =   432
      Left            =   6912
      TabIndex        =   16
      Top             =   2484
      Width           =   1404
   End
   Begin BarCode BarCode1 
      AlignH          =   0  'Left
      AlignV          =   0  'Top
      AutoSize        =   3  'Both
      BarCodeType     =   0  'Code 3 of 9
      BorderStyle     =   0  'None
      Caption         =   ""
      CaptionPosition =   0  'Bottom Left
      Checksum        =   0
      FontBold        =   -1  'True
      FontName        =   "Arial"
      FontSize        =   10.8
      Height          =   1260
      Left            =   204
      Ratio           =   0  '3:1
      Rotation        =   0  'Normal
      ScaleBarHeight  =   1260
      ScaleHeight     =   1260
      ScaleLeft       =   0
      ScaleMode       =   1  'Twip
      ScaleNarrowBarWidth=   24
      ScaleOffsetH    =   0
      ScaleOffsetV    =   0
      ScaleTop        =   0
      ScaleWidth      =   8256
      Text            =   ""
      Top             =   3072
      Width           =   8256
   End
   Begin CommandButton PrintBtn 
      Caption         =   "&Print..."
      Height          =   432
      Left            =   1980
      TabIndex        =   13
      Top             =   2484
      Width           =   1404
   End
   Begin Label Label1 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Bar Code Type:"
      Height          =   312
      Left            =   60
      TabIndex        =   17
      Top             =   1272
      Width           =   1512
   End
   Begin Label Label2 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Ratio:"
      Height          =   312
      Left            =   60
      TabIndex        =   27
      Top             =   1668
      Width           =   1512
   End
   Begin Label Label3 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Narrow Bar Width:"
      Height          =   312
      Left            =   5064
      TabIndex        =   26
      Top             =   2064
      Width           =   1596
   End
   Begin Label Label6 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Text Value:"
      Height          =   312
      Left            =   60
      TabIndex        =   25
      Top             =   84
      Width           =   1512
   End
   Begin Label Label7 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Caption:"
      Height          =   312
      Left            =   60
      TabIndex        =   24
      Top             =   480
      Width           =   1512
   End
   Begin Label Label8 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Caption Position:"
      Height          =   312
      Left            =   60
      TabIndex        =   23
      Top             =   876
      Width           =   1512
   End
   Begin Label Label9 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Height:"
      Height          =   312
      Left            =   5064
      TabIndex        =   22
      Top             =   1272
      Width           =   1596
   End
   Begin Label Label10 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Rotation:"
      Height          =   312
      Left            =   60
      TabIndex        =   21
      Top             =   2064
      Width           =   1512
   End
   Begin Label Label11 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Barcode Height:"
      Height          =   312
      Left            =   5064
      TabIndex        =   20
      Top             =   1668
      Width           =   1596
   End
   Begin Label Label4 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Scale Mode:"
      Height          =   312
      Left            =   5064
      TabIndex        =   19
      Top             =   876
      Width           =   1596
   End
   Begin Label Label5 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "AutoSize:"
      Height          =   312
      Left            =   5064
      TabIndex        =   18
      Top             =   480
      Width           =   1596
   End
End
Option Explicit
Dim ErrCode%
Dim Ok%
Const MsgBoxType% = 64
Const MsgBoxTitle$ = "Create A Barcode!"

Sub AutoSize_LostFocus ()
  BarCode1.AutoSize = AutoSize.ListIndex
  BarCode1.ScaleBarHeight = Val(BarHeight.Text)
End Sub

Sub BarCodeType_LostFocus ()
  BarCode1.BarCodeType = BarCodeType.ListIndex
End Sub

Sub BarHeight_LostFocus ()
  If Val(BarHeight.Text) > 0 Then
    BarCode1.ScaleBarHeight = Val(BarHeight.Text)
  Else
    Beep
    MsgBox "Barcode Height must be greater than zero!", 16, MsgBoxTitle
    BarHeight.SetFocus
    BarHeight.Text = Val(BarCode1.ScaleBarHeight)
  End If
End Sub

Sub CancelBtn_Click ()
  Unload Me
End Sub

Sub CaptionPosition_LostFocus ()
  BarCode1.CaptionPosition = CaptionPosition.ListIndex
End Sub

Sub CaptionText_Change ()
  BarCode1.Caption = CaptionText.Text
End Sub

Sub ClipboardBtn_Click ()
  BarCode1.Action = 2
End Sub

Sub ErrorBtn_Click ()
  ErrCode = BarCodeGetLastErrorCode()
  MsgBox Str$(ErrCode) & "-" & BarCodeGetLastErrorString(), MsgBoxType, MsgBoxTitle
End Sub

Sub FontBtn_Click ()
  Dim Canceled%

  Canceled = False

  On Error GoTo FontDlgErr

  CMDialog1.Flags = 1
  CMDialog1.Action = 4

  If Canceled = False Then
    BarCode1.FontName = CMDialog1.FontName
    BarCode1.FontSize = CMDialog1.FontSize
    BarCode1.FontBold = CMDialog1.FontBold
  End If

  Exit Sub

FontDlgErr:
  If Err = 32755 Then
    Canceled = True
  End If
  Resume Next
End Sub

Sub Form_Load ()
  CenterWindow Me

  CaptionPosition.AddItem ("0 - Bottom Left")
  CaptionPosition.AddItem ("1 - Bottom Center")
  CaptionPosition.AddItem ("2 - Bottom Right")
  CaptionPosition.AddItem ("3 - Top Left")
  CaptionPosition.AddItem ("4 - Top Center")
  CaptionPosition.AddItem ("5 - Top Right")

  BarCodeType.AddItem ("0 - Code 3 of 9")
  BarCodeType.AddItem ("1 - Extended Code 3 of 9")
  BarCodeType.AddItem ("2 - Interleaved 2 of 5")
  BarCodeType.AddItem ("3 - Code 93")
  BarCodeType.AddItem ("4 - Extended Code 93")
  BarCodeType.AddItem ("5 - UPCA")
  BarCodeType.AddItem ("6 - UPCE 10 digit")
  BarCodeType.AddItem ("7 - UPCE0 6 digit")
  BarCodeType.AddItem ("8 - UPCE1 6 digit")
  BarCodeType.AddItem ("9 - EAN 13")
  BarCodeType.AddItem ("10 - EAN 8")
  BarCodeType.AddItem ("11 - Code 128 Auto")
  BarCodeType.AddItem ("12 - Code 128 A")
  BarCodeType.AddItem ("13 - Code 128 B")
  BarCodeType.AddItem ("14 - Code 128 C")
  BarCodeType.AddItem ("15 - Codabar")
  BarCodeType.AddItem ("16 - MSI Plessy")
  BarCodeType.AddItem ("17 - UCC-128")
  BarCodeType.AddItem ("18 - POSTNET (Zip+4 Postal Code)")
  
  Ratio.AddItem ("0 - 3:1")
  Ratio.AddItem ("1 - 2.5:1")
  Ratio.AddItem ("2 - 2:1")

  Rotation.AddItem ("0 - Normal")
  Rotation.AddItem ("1 - Right")
  Rotation.AddItem ("2 - Upside Down")
  Rotation.AddItem ("3 - Left")

  AutoSize.AddItem ("0 - None")
  AutoSize.AddItem ("1 - Height")
  AutoSize.AddItem ("2 - Width")
  AutoSize.AddItem ("3 - Both")

  theScaleMode.AddItem ("0 - User")
  theScaleMode.AddItem ("1 - Twip")
  theScaleMode.AddItem ("2 - Point")
  theScaleMode.AddItem ("3 - Pixel")
  theScaleMode.AddItem ("4 - Character")
  theScaleMode.AddItem ("5 - Inch")
  theScaleMode.AddItem ("6 - Millimeter")
  theScaleMode.AddItem ("7 - Centimeter")

  AutoCaption.Value = 1
  CaptionText.Text = BarCode1.Caption
  BarCodeType.ListIndex = BarCode1.BarCodeType
  Ratio.ListIndex = BarCode1.Ratio
  NarrWidth.Text = LTrim(Str(BarCode1.ScaleNarrowBarWidth))
  CaptionPosition.ListIndex = BarCode1.CaptionPosition
  Rotation.ListIndex = BarCode1.Rotation
  If Rotation.ListIndex = 1 Or Rotation.ListIndex = 3 Then
    TotalHeight.Text = BarCode1.Width
  Else
    TotalHeight.Text = BarCode1.Height
  End If
  BarHeight.Text = Val(BarCode1.ScaleBarHeight)
  AutoSize.ListIndex = BarCode1.AutoSize
  theScaleMode.ListIndex = BarCode1.ScaleMode
  CMDialog1.FontName = BarCode1.FontName
  CMDialog1.FontSize = BarCode1.FontSize
  CMDialog1.FontBold = BarCode1.FontBold
End Sub

Sub NarrWidth_LostFocus ()
  If Val(NarrWidth.Text) > 0 Then
    BarCode1.ScaleNarrowBarWidth = Val(NarrWidth.Text)
  Else
    Beep
    MsgBox "Narrow Bar Width must be greater than zero!", 16, MsgBoxTitle
    NarrWidth.SetFocus
    NarrWidth.Text = LTrim(Str(BarCode1.ScaleNarrowBarWidth))
  End If
End Sub

Sub PrintBtn_Click ()
  Dim DOCINFO As DOCINFO
  Dim StopPrint As Integer

  StopPrint = False
  On Error GoTo PrintErr:
				   
  CMDialog1.Flags = PD_RETURNDC Or PD_PRINTSETUP
  CMDialog1.Action = 5
    
  If StopPrint = False Then
    Screen.MousePointer = 11

    DOCINFO.cbSize = 0
    DOCINFO.DocName = 0
    DOCINFO.Output = 0

    Ok = StartDoc(CMDialog1.hDC, DOCINFO)
    Ok = StartPage(CMDialog1.hDC)

    BarCode1.PrinterHDC = CMDialog1.hDC
    If BarCodeGetLastErrorCode() <> False Then
      MsgBox BarCodeGetLastErrorString()
    End If

    Ok = EndPage(CMDialog1.hDC)
    Ok = EndDocAPI(CMDialog1.hDC)
    Ok = DeleteDC(CMDialog1.hDC)
    Screen.MousePointer = 0
  End If

  On Error GoTo 0
Exit Sub

PrintErr:
  StopPrint = True
  Resume Next
End Sub

Sub Ratio_LostFocus ()
  BarCode1.Ratio = Ratio.ListIndex
End Sub

Sub Rotation_LostFocus ()
  BarCode1.Rotation = Rotation.ListIndex
  If Rotation.ListIndex = 1 Or Rotation.ListIndex = 3 Then
    TotalHeight.Text = BarCode1.Width
  Else
    TotalHeight.Text = BarCode1.Height
  End If
  BarHeight.Text = Val(BarCode1.ScaleBarHeight)
End Sub

Sub Text_Change ()
  BarCode1.Text = Text.Text
  If AutoCaption.Value = 1 Then
    CaptionText.Text = Text.Text
    If BarCode1.BarCodeType >= 5 And BarCode1.BarCodeType <= 10 Then
      CaptionText.Text = CaptionText.Text & BarCode1.ChecksumString
    End If
  End If
End Sub

Sub theScaleMode_LostFocus ()
  BarCode1.ScaleMode = theScaleMode.ListIndex
  NarrWidth.Text = LTrim(Str(BarCode1.ScaleNarrowBarWidth))
  BarHeight.Text = Val(BarCode1.ScaleBarHeight)
End Sub

Sub TotalHeight_LostFocus ()
  If Val(TotalHeight.Text) > 0 Then
    If Rotation.ListIndex = 1 Or Rotation.ListIndex = 3 Then
      BarCode1.Width = Val(TotalHeight.Text)
    Else
      BarCode1.Height = Val(TotalHeight.Text)
    End If
  Else
    Beep
    MsgBox "Height must be greater than zero!", 16, MsgBoxTitle
    TotalHeight.SetFocus
    If Rotation.ListIndex = 1 Or Rotation.ListIndex = 3 Then
      TotalHeight.Text = BarCode1.Width
    Else
      TotalHeight.Text = BarCode1.Height
    End If
  End If
End Sub

